int g_sas : SasGlobal
<
    int3 SasVersion = {1, 0, 0};
>;

matrix	g_world_matrix : WORLD;
matrix	g_view_projection_matrix : VIEWPROJECTION;
texture g_tex0;

struct VS_INPUT
{
    vector pos : POSITION;
    vector norm : NORMAL;
    float2 tex : TEXCOORD0;
};

struct VS_OUTPUT
{
    vector pos : POSITION;
    float2 tex1 : TEXCOORD0;
};

sampler Tex01 = sampler_state
{
    Texture   = (g_tex0);
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

VS_OUTPUT vs_main(VS_INPUT input)
{
    VS_OUTPUT output = (VS_OUTPUT)0;

    output.pos = mul( input.pos , g_world_matrix );
    output.pos = mul( output.pos , g_view_projection_matrix );

  
    output.tex1 = input.tex;
    
    return output;
}

float4 ps_main( float2 tex1 : TEXCOORD0 ) : COLOR0
{	
	return float4( tex2D( Tex01 , tex1 ) ) ;
}

technique Basic
{
    pass P0
    {		
        VertexShader = compile vs_3_0 vs_main();
        PixelShader = compile ps_2_0 ps_main();
    }
}